package ru.yandex.webmaster.support.http.servantlet.host;

import java.net.IDN;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster.common.WebmasterException;
import ru.yandex.webmaster.common.WebmasterExceptionType;
import ru.yandex.webmaster.common.http.Action;
import ru.yandex.webmaster.common.http.RequestFilter;
import ru.yandex.webmaster.common.http.response.HostResponse;
import ru.yandex.webmaster.support.http.servantlet.filter.SupportUserFilter;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.UsersHostsInfo;
import ru.yandex.wmconsole.service.HostInfoService;
import ru.yandex.wmconsole.service.UsersHostsService;

/**
 * @author aherman
 */
public class GetUserVerificationStatusAction extends Action<GetUserVerificationStatusRequest, GetUserVerificationStatusResponse> {
    private UsersHostsService usersHostsService;
    private HostInfoService hostInfoService;

    @Override
    public GetUserVerificationStatusResponse process(GetUserVerificationStatusRequest request) throws Exception {

        GetUserVerificationStatusResponse response;
        BriefHostInfo briefHostInfo =
                hostInfoService.getBriefHostInfoByIdOrName(StringUtils.trim(request.getHostname()));
        if (briefHostInfo == null) {
            throw new WebmasterException(WebmasterExceptionType.HOST__UNKNOWN_HOST, "Unknown host: " + request.getHostname());
        }

        List<UsersHostsInfo> userHostInfo =
                usersHostsService.findUserHostInfo(briefHostInfo, Collections.singleton(request.getForUserId()));

        List<GetUserVerificationStatusResponse.VerificationInfo> verificationInfos = new ArrayList<>(userHostInfo.size());
        for (UsersHostsInfo info : userHostInfo) {
            verificationInfos.add(new GetUserVerificationStatusResponse.VerificationInfo(
                    info.getHostId(),
                    info.getUserId(),
                    info.getVerificationUin(),
                    info.getVerificationType(),
                    info.getVerificationState(),
                    info.getVerifyFaultLog(),
                    info.getVerificationDate() != null ? new DateTime(info.getVerificationDate()) : null
            ));
        }
        response = new GetUserVerificationStatusResponse(
                new HostResponse(briefHostInfo.getId(), briefHostInfo.getName(), IDN.toUnicode(
                        briefHostInfo.getName())), verificationInfos);
        return response;
    }

    @Override
    public List<Class<? extends RequestFilter>> getRequestFilters() {
        List<Class<? extends RequestFilter>> requestFilters = super.getRequestFilters();
        requestFilters.add(SupportUserFilter.class);
        return requestFilters;
    }

    @Required
    public void setUsersHostsService(UsersHostsService usersHostsService) {
        this.usersHostsService = usersHostsService;
    }

    @Required
    public void setHostInfoService(HostInfoService hostInfoService) {
        this.hostInfoService = hostInfoService;
    }
}
