package ru.yandex.webmaster.support.http.servantlet.host;

import java.util.List;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import org.joda.time.DateTime;

import ru.yandex.webmaster.common.http.ActionResponse;
import ru.yandex.webmaster.common.http.response.HostResponse;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

/**
 * @author aherman
 */
public class GetUserVerificationStatusResponse implements ActionResponse {
    private final HostResponse host;
    private final List<VerificationInfo> verificationInfos;

    public GetUserVerificationStatusResponse(HostResponse host,
            List<VerificationInfo> verificationInfos) {
        this.host = host;
        this.verificationInfos = verificationInfos;
    }

    public HostResponse getHost() {
        return host;
    }

    @JacksonXmlProperty(localName = "verificationInfo")
    @JacksonXmlElementWrapper(localName = "verificationInfos")
    public List<VerificationInfo> getVerificationInfos() {
        return verificationInfos;
    }

    public static class VerificationInfo {
        private final long hostId;
        private final long userId;
        private final long verificationUin;
        private final VerificationTypeEnum verificationType;
        private final VerificationStateEnum verificationState;
        private final String verifictionLog;
        private final DateTime verificationDate;

        public VerificationInfo(long hostId, long userId, long verificationUin, VerificationTypeEnum verificationType,
                VerificationStateEnum verificationState, String verifictionLog, DateTime verificationDate)
        {
            this.hostId = hostId;
            this.userId = userId;
            this.verificationUin = verificationUin;
            this.verificationType = verificationType;
            this.verificationState = verificationState;
            this.verifictionLog = verifictionLog;
            this.verificationDate = verificationDate;
        }

        public long getHostId() {
            return hostId;
        }

        public long getUserId() {
            return userId;
        }

        public VerificationTypeEnum getVerificationType() {
            return verificationType;
        }

        public VerificationStateEnum getVerificationState() {
            return verificationState;
        }

        public long getVerificationUin() {
            return verificationUin;
        }

        public String getVerifictionLog() {
            return verifictionLog;
        }

        public DateTime getVerificationDate() {
            return verificationDate;
        }
    }
}
