package ru.yandex.wmconsole.servantlet;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmconsole.data.info.AddUrlInfo;
import ru.yandex.wmconsole.data.wrappers.AddUrlInfoWrapper;
import ru.yandex.wmconsole.service.CrawlUrlService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * Encodes urls using punycode and performs some checks.
 * Reports when urls are invalid.
 *
 * @author ailyin
 */
public class CrawlUrlServantlet extends AuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(CrawlUrlServantlet.class);

    private static final String PARAM_URLS = "urls";
    private static final String PARAM_URLS2 = "urls2";

    private CrawlUrlService crawlUrlService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) {
        log.debug("CrawlUrl: Started");

        String[] urls = splitInput(req.getParam(PARAM_URLS));
        String[] urls2 = splitInput(req.getParam(PARAM_URLS2));

        List<XmlConvertable> results = new ArrayList<XmlConvertable>();
        processUrls(urls, results, false, userId);
        processUrls(urls2, results, true, userId);
        res.addData(new XmlConvertableCollectionWrapper(results, "crawlurl"));

        log.debug("CrawlUrl: Finished");
    }

    private void processUrls(String[] urls, List<XmlConvertable> results, boolean rewriteUrl, long userId) {
        for (String url : urls) {
            try {
                crawlUrlService.crawlUrl(prepareUrl(url, true), rewriteUrl, userId);
            } catch (UserException e) {
                results.add(new AddUrlInfoWrapper(new AddUrlInfo(url, e.getProblem().toString())));
            } catch (InternalException e) {
                results.add(new AddUrlInfoWrapper(new AddUrlInfo(url, e.getProblem().toString())));
            }
        }
    }

    @Required
    public void setCrawlUrlService(CrawlUrlService crawlUrlService) {
        this.crawlUrlService = crawlUrlService;
    }
}
