package ru.yandex.wmconsole.servantlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.UsersHostsInfo;
import ru.yandex.wmconsole.data.wrappers.UsersHostsInfoWrapper;
import ru.yandex.wmconsole.util.HostCollectionWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

public class HostSummaryServantlet extends WMCAuthenticationServantlet {
    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {

        BriefHostInfo hostInfo = getHostInfo(req);

        Collection<XmlConvertable> col = new ArrayList<XmlConvertable>();
        List<UsersHostsInfo> usersForHost = getUsersHostsService().listUsersForHost(hostInfo.getId());
        col.add(XmlConvertableCollectionWrapper.wrap(usersForHost, UsersHostsInfoWrapper.class, "all-users"));

        res.addData(new HostCollectionWrapper(col, hostInfo));
    }
}
