package ru.yandex.wmconsole.servantlet;

import java.net.URL;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.ToolEnum;
import ru.yandex.wmconsole.data.info.LogInfo;
import ru.yandex.wmconsole.data.wrappers.LogInfoWrapper;
import ru.yandex.wmconsole.service.LogViewerService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * @author ailyin
 */
public class LogViewerServantlet extends AuthenticationServantlet {
    private static final String PARAM_TOOL = "tool";
    private static final String PARAM_URL = "url";

    private LogViewerService logViewerService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        URL url = prepareUrl(getRequiredStringParam(req, PARAM_URL).trim(), true);
        int toolParam = getRequiredIntParam(req, PARAM_TOOL);
        ToolEnum tool = ToolEnum.R.fromValueOrNull(toolParam);
        if (tool == null) {
            throw new UserException(UserProblem.ILLEGAL_PARAM_VALUE, "Invalid param: " + PARAM_TOOL,
                    PARAM_TOOL, Integer.toString(toolParam));
        }

        List<LogInfo> infos = logViewerService.getLogInfo(url, tool);
        res.addData(XmlConvertableCollectionWrapper.wrap(infos, LogInfoWrapper.class, "log-infos"));
    }

    @Required
    public void setLogViewerService(LogViewerService logViewerService) {
        this.logViewerService = logViewerService;
    }
}
