package ru.yandex.wmconsole.servantlet;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.user.UserInfo;
import ru.yandex.wmtools.common.data.wrappers.BlackBoxUserInfoWrapper;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;

public class UserInfoServantlet extends WMCAuthenticationServantlet {
    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException {
        long givenUserId = getUserIdByNameOrId(req, PARAM_USER);

        final UserInfo userInfo = getUserInfoService().getPassportUserInfo(givenUserId);
        if (userInfo == null) {
            throw new UserException(UserProblem.NO_SUCH_USER_IN_PASSPORT, "User " + givenUserId + " not found in passport");
        }
        res.addData(new BlackBoxUserInfoWrapper(userInfo));
    }
}
