package ru.yandex.wmconsole.servantlet;

import java.util.List;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmtools.common.data.info.VisitingStatInfo;
import ru.yandex.wmtools.common.data.wrappers.VisitingStatInfoWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

public class VisitingStatServantlet extends WMCAuthenticationServantlet {
    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws
            InternalException, UserException {

        Long forUserId = null;
        try {
            forUserId = getAndCheckUserIdByNameOrId(req);
        } catch (UserException e) {
            if (!UserProblem.REQUIRED_PARAM_MISSED.equals(e.getProblem())) {
                throw e;
            }
        }

        List<VisitingStatInfo> visitingStats = getVisitingStatService().getVisitingStatForLastWeek(forUserId);

        res.addData(XmlConvertableCollectionWrapper.wrap(visitingStats, VisitingStatInfoWrapper.class, "stats"));
    }
}
