package ru.yandex.wmconsole.servantlet.all.about.url;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;

import java.net.URL;

/**
 * User: azakharov
 * Date: 21.01.14
 * Time: 14:15
 */
public class SupportAddAllAboutUrlRequestServantlet extends AbstractSupportAllAboutUrlServantlet {
    private static final String PARAM_URL = "url";

    private static final String TAG_HOST = "host";

    @Override
    protected void processUrlRequest(ServRequest req, ServResponse res, long userId, BriefHostInfo hostInfo) throws InternalException, UserException {
        String urlParam = getRequiredStringParam(req, PARAM_URL);
        if (hostInfo == null) {
            throw new UserException(UserProblem.HOST_NOT_FOUND_IN_DATABASE, "Host not found in database");
        }
        // Проверяем, что URL относится к хосту
        URL url = getAllAboutUrlService().getUrlAndCheckUrlIsFromHost(hostInfo, urlParam, userId, true);
        // Записываем запрос в базу
        getAllAboutUrlService().addUrlRequest(hostInfo, url, true);
        res.addData(new HostElementWrapper(null, hostInfo, TAG_HOST));
    }
}
