package ru.yandex.wmconsole.servantlet.all.about.url;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.webmaster.viewer.view.all.about.url.DumpAllAboutUrlTablesWrapper;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.all.about.url.UrlInfo;
import ru.yandex.wmconsole.data.info.all.about.url.UrlInfoXml;
import ru.yandex.wmconsole.data.info.all.about.url.UrlRequestId;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

import java.util.Map;

/**
 * User: azakharov
 * Date: 21.01.14
 * Time: 18:33
 */
public class SupportUrlInfoServantlet extends AbstractSupportAllAboutUrlServantlet {

    private static final String PARAM_DUMP = "dump";

    @Override
    protected void processUrlRequest(ServRequest req, ServResponse res, long userId, BriefHostInfo hostInfo) throws InternalException, UserException {
        UrlRequestId id = getRequestId(req);
        UrlInfo urlInfo = getAllAboutUrlService().getUrlInfo(hostInfo, id, true);
        res.addData(new UrlInfoXml(urlInfo));

        boolean dump = getBooleanParam(req, PARAM_DUMP, false);
        if (dump) {
            Map<String, Map<String, Object>> results = getAllAboutUrlService().dumpAllAboutUrlInfo(hostInfo, id);
            res.addData(new DumpAllAboutUrlTablesWrapper(results));
        }
    }
}
