package ru.yandex.wmconsole.servantlet.blocked;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.UserBlockReason;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.BlockedUsersService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

public class AddBlockedServantlet extends WMCAuthenticationServantlet {
    private static final String PARAM_BLOCK_REASON = "block_reason";

    private BlockedUsersService blockedUsersService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(blockedUsersService, BlockedUsersService.class);
        long blockedId = getAndCheckUserIdByNameOrId(req);
        String blockReasonValue = req.getParam(PARAM_BLOCK_REASON);
        UserBlockReason userBlockReason = UserBlockReason.R.valueOfOrUnknown(blockReasonValue);
        blockedUsersService.addBlockedUser(req.getUserId(), blockedId, userBlockReason);
    }

    @Required
    public void setBlockedUsersService(BlockedUsersService blockedUsersService) {
        this.blockedUsersService = blockedUsersService;
    }
}
