package ru.yandex.wmconsole.servantlet.blocked;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmconsole.data.BlockedUserInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.BlockedUsersService;
import ru.yandex.wmtools.common.data.info.WMUserInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class BlockedListServantlet extends WMCAuthenticationServantlet {
    private BlockedUsersService blockedUsersService;

    /**
     * Get list of blocked users or check is user given in optional param "user" is blocked or not.
     * Can return NO_SUCH_USER_IN_SERVICE in case user given in "user" param is not registred in service
     *
     * @param req    request
     * @param res    response
     * @param userId support user id
     * @throws UserException
     * @throws InternalException
     */
    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(blockedUsersService, BlockedUsersService.class);

        Pager pager = createOutputStrategy(req).createPager();
        List<Pair<WMUserInfo, BlockedUserInfo>> blockedUsers = new ArrayList<Pair<WMUserInfo, BlockedUserInfo>>();
        String givenUser = getStringParam(req, PARAM_USER);
        if (givenUser != null) {
            long givenUserId = getUserInfoService().getUserIdByNameOrId(givenUser, PARAM_USER);
            WMUserInfo givenUserInfo = getUserInfoService().getUserInfo(givenUserId);
            if (givenUserInfo.isBlocked()) {
                BlockedUserInfo blockInfo = blockedUsersService.getBlockInfo(givenUserId);
                blockedUsers.add(Pair.of(givenUserInfo, blockInfo));
            }
        } else {
            blockedUsers = blockedUsersService.getBlockedUserInfoList(pager);
        }
        res.addData(XmlConvertableCollectionWrapper.wrap(blockedUsers, BlockedUserInfoWrapper.class, "blocked-users"));
        res.addData(pager);
    }

    @Required
    public void setBlockedUsersService(BlockedUsersService blockedUsersService) {
        this.blockedUsersService = blockedUsersService;
    }

    public static class BlockedUserInfoWrapper extends XmlDataWrapper<Pair<WMUserInfo, BlockedUserInfo>> {

        private final XmlConvertable[] additionalInfo;

        public BlockedUserInfoWrapper(Pair<WMUserInfo, BlockedUserInfo> data) {
            this(data, "user");
        }

        public BlockedUserInfoWrapper(Pair<WMUserInfo, BlockedUserInfo> data, String tagName, XmlConvertable... additionalInfo) {
            super(data, tagName, "id", Long.toString(data.getFirst().getUserId()));
            this.additionalInfo = additionalInfo;
        }

        @Override
        protected void doToXml(StringBuilder result) {
            if (data.getFirst().getLogin() != null) {
                putTag(result, "login", data.getFirst().getLogin());
            }
            if (data.getFirst().getFIO() != null) {
                putTag(result, "fio", data.getFirst().getFIO());
            }
            putTag(result, "block-reason", data.getSecond().getBlockReason().name());
            putTag(result, "block-date", data.getSecond().getBlockDate().toString());
            putTag(result, "block-by-user-id", String.valueOf(data.getSecond().getBlockedByUserId()));

            if (additionalInfo != null && additionalInfo.length > 0) {
                for (XmlConvertable element : additionalInfo) {
                    element.toXml(result);
                }
            }

        }
    }
}
