package ru.yandex.wmconsole.servantlet.blocked;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.BlockedUsersService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;

public class RemoveBlockedServantlet extends AuthenticationServantlet {
    private static final String PARAM_REMOVE = "remove";

    private BlockedUsersService blockedUsersService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(blockedUsersService, BlockedUsersService.class);
        Long[] supportIds = getMultiParamLong(req, PARAM_REMOVE);
        if (supportIds.length > 0) {
            blockedUsersService.removeBlockedUsers(req.getUserId(), supportIds);
        }
    }

    @Required
    public void setBlockedUsersService(BlockedUsersService blockedUsersService) {
        this.blockedUsersService = blockedUsersService;
    }
}
