package ru.yandex.wmconsole.servantlet.drafts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.WMCHistoryObjectTypeEnum;
import ru.yandex.wmconsole.service.GlobalDraftMessagesService;
import ru.yandex.wmconsole.service.HostOwnersDraftMessagesService;
import ru.yandex.wmconsole.service.PersonalDraftMessagesService;
import ru.yandex.wmtools.common.data.wrappers.SimpleWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.SqlUtil;

public class DraftMessageAddServantlet extends AuthenticationServantlet {
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_RECIPIENTS = "recipients";
    private static final String PARAM_HOSTS = "hosts";

    private GlobalDraftMessagesService globalDraftMessagesService;
    private PersonalDraftMessagesService personalDraftMessagesService;
    private HostOwnersDraftMessagesService hostOwnersDraftMessagesService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(globalDraftMessagesService, GlobalDraftMessagesService.class);

        WMCHistoryObjectTypeEnum type = WMCHistoryObjectTypeEnum.R.fromValueOrNull(getRequiredByteParam(req, PARAM_TYPE));

        // add message
        long messageId = 0;
        Set<String> incorrectRecipientsList = new TreeSet<String>();
        List<String> incorrectHosts = new ArrayList<String>();

        switch (type) {
            case GLOBAL_MESSAGE: {
                messageId = globalDraftMessagesService.addNewMessage(userId);
            }
            break;
            case PERSONAL_MESSAGE: {
                String recipients = getStringParam(req, PARAM_RECIPIENTS);
                messageId = personalDraftMessagesService.addNewMessage(userId, recipients, incorrectRecipientsList);
            }
            break;
            case HOST_OWNERS_MESSAGE: {
                String hosts = getStringParam(req, PARAM_HOSTS);
                List<String> hostList = new ArrayList<String>();
                if (hosts != null && !hosts.trim().isEmpty()) {
                    hostList = Arrays.asList(hosts.split("\\s*,\\s*"));
                }
                messageId = hostOwnersDraftMessagesService.addNewMessage(userId, hostList, incorrectHosts);
            }
            break;
            default: {
                throw new UserException(UserProblem.ILLEGAL_PARAM_VALUE, "Illegal type of message", PARAM_TYPE, Integer.toString(type.getValue()));
            }
        }

        res.addData(new SimpleWrapper<String>(SqlUtil.getCommaSeparatedList(incorrectHosts), "incorrect-hosts"));
        res.addData(new SimpleWrapper<String>(SqlUtil.getCommaSeparatedList(incorrectRecipientsList), "incorrect-recipients"));
        res.addData(new SimpleWrapper<Long>(messageId, "message"));
    }

    @Required
    public void setGlobalDraftMessagesService(GlobalDraftMessagesService globalDraftMessagesService) {
        this.globalDraftMessagesService = globalDraftMessagesService;
    }

    @Required
    public void setPersonalDraftMessagesService(PersonalDraftMessagesService personalDraftMessagesService) {
        this.personalDraftMessagesService = personalDraftMessagesService;
    }

    @Required
    public void setHostOwnersDraftMessagesService(HostOwnersDraftMessagesService hostOwnersDraftMessagesService) {
        this.hostOwnersDraftMessagesService = hostOwnersDraftMessagesService;
    }
}
