package ru.yandex.wmconsole.servantlet.drafts;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.data.info.DraftMessageInfo;
import ru.yandex.wmconsole.service.GlobalDraftMessagesService;
import ru.yandex.wmtools.common.data.info.HistoryInfo;
import ru.yandex.wmtools.common.data.wrappers.HistoryInfoWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.service.HistoryService;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

public class DraftMessageHistoryListServantlet extends AuthenticationServantlet {
    private static final String PARAM_MESSAGE_ID = "message";

    private HistoryService historyService;
    private GlobalDraftMessagesService draftMessagesService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(historyService, HistoryService.class);
        checkService(draftMessagesService, GlobalDraftMessagesService.class);

        long messageId = getRequiredLongParam(req, PARAM_MESSAGE_ID);

        Pager pager = getOutputStrategy().createPager();

        DraftMessageInfo message = draftMessagesService.getAbstractDraftMessage(messageId);
        List<HistoryInfo> historyList = historyService.getHistoryListForObject(messageId, pager, message.getType());
        res.addData(XmlConvertableCollectionWrapper.wrap(historyList, HistoryInfoWrapper.class, "history-list"));
        res.addData(pager);
    }

    @Required
    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    @Required
    public void setGlobalDraftMessagesService(GlobalDraftMessagesService globalDraftMessagesService) {
        this.draftMessagesService = globalDraftMessagesService;
    }
}
