package ru.yandex.wmconsole.servantlet.drafts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.HostOwnersDraftMessagesService;
import ru.yandex.wmtools.common.data.wrappers.SimpleWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.SqlUtil;

/**
 * @author avhaliullin
 */
public class DraftMessageHostsAddServantlet extends AuthenticationServantlet {
    private static final String PARAM_MESSAGE_ID = "message";
    private static final String PARAM_HOSTS = "hosts";

    private HostOwnersDraftMessagesService draftMessagesService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(draftMessagesService, HostOwnersDraftMessagesService.class);

        long messageId = getRequiredLongParam(req, PARAM_MESSAGE_ID);
        String hosts = getStringParam(req, PARAM_HOSTS);
        List<String> incorrectHostsList = new ArrayList<String>();

        if (hosts != null && !hosts.trim().isEmpty()) {
            List<String> hostList = Arrays.asList(hosts.split("\\s*,\\s*"));
            draftMessagesService.addHosts(userId, messageId, hostList, incorrectHostsList);
        }

        res.addData(new SimpleWrapper<String>(SqlUtil.getCommaSeparatedList(incorrectHostsList), "incorrect-hosts"));
        res.addData(new SimpleWrapper<Long>(messageId, "message"));
    }

    @Required
    public void setHostOwnersDraftMessagesService(HostOwnersDraftMessagesService draftMessagesService) {
        this.draftMessagesService = draftMessagesService;
    }
}
