package ru.yandex.wmconsole.servantlet.drafts;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.HostOwnersDraftMessagesService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;

/**
 * @author avhaliullin
 */
public class DraftMessageHostsRemoveServantlet extends AuthenticationServantlet {
    private static final String PARAM_MESSAGE_ID = "message";
    private static final String PARAM_REMOVE = "remove";

    private HostOwnersDraftMessagesService draftMessagesService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(draftMessagesService, HostOwnersDraftMessagesService.class);

        long messageId = getRequiredLongParam(req, PARAM_MESSAGE_ID);
        Long[] hosts = getMultiParamLong(req, PARAM_REMOVE);

        // remove recipients
        draftMessagesService.removeHosts(userId, messageId, hosts);
    }

    @Required
    public void setHostOwnersDraftMessagesService(HostOwnersDraftMessagesService draftMessagesService) {
        this.draftMessagesService = draftMessagesService;
    }
}
