package ru.yandex.wmconsole.servantlet.drafts;

import java.util.Set;
import java.util.TreeSet;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.PersonalDraftMessagesService;
import ru.yandex.wmtools.common.data.wrappers.SimpleWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.SqlUtil;

public class DraftMessageRecipientsAddServantlet extends AuthenticationServantlet {
    private static final String PARAM_MESSAGE_ID = "message";
    private static final String PARAM_RECIPIENTS = "recipients";

    private PersonalDraftMessagesService draftMessagesService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(draftMessagesService, PersonalDraftMessagesService.class);

        long messageId = getRequiredLongParam(req, PARAM_MESSAGE_ID);
        String recipients = getStringParam(req, PARAM_RECIPIENTS);

        // add recipients
        Set<String> incorrectRecipientsList = new TreeSet<String>();
        draftMessagesService.addRecipients(userId, messageId, recipients, incorrectRecipientsList);

        res.addData(new SimpleWrapper<String>(SqlUtil.getCommaSeparatedList(incorrectRecipientsList), "incorrect-recipients"));
        res.addData(new SimpleWrapper<Long>(messageId, "message"));
    }

    @Required
    public void setPersonalDraftMessagesService(PersonalDraftMessagesService draftMessagesService) {
        this.draftMessagesService = draftMessagesService;
    }
}
