package ru.yandex.wmconsole.servantlet.drafts;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.PersonalDraftMessagesService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;

public class DraftMessageRecipientsRemoveServantlet extends AuthenticationServantlet {
    private static final String PARAM_MESSAGE_ID = "message";
    private static final String PARAM_REMOVE = "remove";

    private PersonalDraftMessagesService draftMessagesService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(draftMessagesService, PersonalDraftMessagesService.class);

        long messageId = getRequiredLongParam(req, PARAM_MESSAGE_ID);
        Long[] recipientIds = getMultiParamLong(req, PARAM_REMOVE);

        // remove recipients
        draftMessagesService.removeRecipients(userId, messageId, recipientIds);
    }

    @Required
    public void setPersonalDraftMessagesService(PersonalDraftMessagesService draftMessagesService) {
        this.draftMessagesService = draftMessagesService;
    }
}
