package ru.yandex.wmconsole.servantlet.drafts;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.GlobalDraftMessagesService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;

public class DraftMessageRemoveServantlet extends AuthenticationServantlet {
    private static final String PARAM_MESSAGE_ID = "message";

    private GlobalDraftMessagesService draftMessagesService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(draftMessagesService, GlobalDraftMessagesService.class);

        long messageId = getRequiredLongParam(req, PARAM_MESSAGE_ID);

        // remove message
        draftMessagesService.removeMessage(messageId, userId);
    }

    @Required
    public void setGlobalDraftMessagesService(GlobalDraftMessagesService draftMessagesService) {
        this.draftMessagesService = draftMessagesService;
    }
}
