package ru.yandex.wmconsole.servantlet.drafts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.LanguageEnum;
import ru.yandex.wmconsole.data.info.DraftMessageInfo;
import ru.yandex.wmconsole.service.GlobalDraftMessagesService;
import ru.yandex.wmconsole.service.HostOwnersDraftMessagesService;
import ru.yandex.wmconsole.service.PersonalDraftMessagesService;
import ru.yandex.wmtools.common.data.wrappers.SimpleWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.SqlUtil;

public class DraftMessageSaveServantlet extends AuthenticationServantlet {
    private static final String PARAM_MESSAGE_ID = "message";
    private static final String PARAM_HEADER = "header";
    private static final String PARAM_CONTENT = "content";
    private static final String PARAM_RECIPIENTS = "recipients";
    private static final String PARAM_HOSTS = "hosts";
    private static final String PARAM_LANG = "message-lang";

    private static final String TAG_MESSAGE = "message";

    private PersonalDraftMessagesService personalDraftMessagesService;
    private GlobalDraftMessagesService globalDraftMessagesService;
    private HostOwnersDraftMessagesService hostOwnersDraftMessagesService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(personalDraftMessagesService, PersonalDraftMessagesService.class);

        long messageId = getRequiredLongParam(req, PARAM_MESSAGE_ID);
        String header = getRequiredStringParam(req, PARAM_HEADER);
        String content = getRequiredStringParam(req, PARAM_CONTENT);
        String recipients = getStringParam(req, PARAM_RECIPIENTS);
        String hosts = getStringParam(req, PARAM_HOSTS);
        String lang = req.getParam(PARAM_LANG, true);
        LanguageEnum language = LanguageEnum.fromString(lang);
        DraftMessageInfo draftMessageInfo = globalDraftMessagesService.getDraftMessage(messageId);

        switch (draftMessageInfo.getType()) {
            case GLOBAL_MESSAGE: {
                globalDraftMessagesService.saveMessage(messageId, userId, header, content, language);
            }
            break;
            case PERSONAL_MESSAGE: {
                Set<String> incorrectRecipientsList = new TreeSet<String>();
                if (recipients != null && !recipients.isEmpty()) {
                    // add recipients
                    personalDraftMessagesService.addRecipients(userId, messageId, recipients, incorrectRecipientsList);
                }

                res.addData(new SimpleWrapper<String>(SqlUtil.getCommaSeparatedList(incorrectRecipientsList), "incorrect-recipients"));
                res.addData(new SimpleWrapper<Long>(messageId, TAG_MESSAGE));
                globalDraftMessagesService.saveMessage(messageId, userId, header, content, language);
            }
            break;
            case HOST_OWNERS_MESSAGE: {
                if (hosts != null && !hosts.trim().isEmpty()) {
                    List<String> incorrectHosts = new ArrayList<String>();
                    List<String> hostList = Arrays.asList(hosts.split("\\s*,\\s*"));
                    hostOwnersDraftMessagesService.addHosts(userId, messageId, hostList, incorrectHosts);
                    res.addData(new SimpleWrapper<String>(SqlUtil.getCommaSeparatedList(incorrectHosts), "incorrect-recipients"));
                    res.addData(new SimpleWrapper<Long>(messageId, TAG_MESSAGE));
                }
                hostOwnersDraftMessagesService.saveMessage(messageId, userId, header, content, language);
            }
        }
    }


    @Required
    public void setPersonalDraftMessagesService(PersonalDraftMessagesService personalDraftMessagesService) {
        this.personalDraftMessagesService = personalDraftMessagesService;
    }

    @Required
    public void setHostOwnersDraftMessagesService(HostOwnersDraftMessagesService hostOwnersDraftMessagesService) {
        this.hostOwnersDraftMessagesService = hostOwnersDraftMessagesService;
    }

    @Required
    public void setGlobalDraftMessagesService(GlobalDraftMessagesService globalDraftMessagesService) {
        this.globalDraftMessagesService = globalDraftMessagesService;
    }
}
