package ru.yandex.wmconsole.servantlet.drafts;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.DraftMessageInfo;
import ru.yandex.wmconsole.data.wrappers.DraftMessageWrapper;
import ru.yandex.wmconsole.data.wrappers.HostOwnersDraftMessageWrapper;
import ru.yandex.wmconsole.data.wrappers.PersonalDraftMessageWrapper;
import ru.yandex.wmconsole.service.GlobalDraftMessagesService;
import ru.yandex.wmconsole.service.HostOwnersDraftMessagesService;
import ru.yandex.wmconsole.service.PersonalDraftMessagesService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;

public class DraftMessageShowServantlet extends AuthenticationServantlet {
    private static final String PARAM_MESSAGE_ID = "message";

    private GlobalDraftMessagesService draftMessagesService;
    private PersonalDraftMessagesService personalDraftMessagesService;
    private HostOwnersDraftMessagesService hostOwnersDraftMessagesService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(draftMessagesService, GlobalDraftMessagesService.class);

        long messageId = getRequiredLongParam(req, PARAM_MESSAGE_ID);

        // get message
        DraftMessageInfo draftMessage = draftMessagesService.getAbstractDraftMessage(messageId);
        switch (draftMessage.getType()) {
            case GLOBAL_MESSAGE: {
                res.addData(new DraftMessageWrapper(draftMessage));
            }
            break;
            case PERSONAL_MESSAGE: {
                res.addData(new PersonalDraftMessageWrapper(personalDraftMessagesService.getDraftMessage(messageId)));
            }
            break;
            case HOST_OWNERS_MESSAGE: {
                res.addData(new HostOwnersDraftMessageWrapper(hostOwnersDraftMessagesService.getDraftMessage(messageId)));
            }
            break;
            default: {
                throw new InternalException(InternalProblem.ILLEGAL_ARGUMENT,
                        "Unknown message type: " + draftMessage.getType());
            }
        }
    }

    @Required
    public void setGlobalDraftMessagesService(GlobalDraftMessagesService draftMessagesService) {
        this.draftMessagesService = draftMessagesService;
    }

    @Required
    public void setPersonalDraftMessagesService(PersonalDraftMessagesService personalDraftMessagesService) {
        this.personalDraftMessagesService = personalDraftMessagesService;
    }

    @Required
    public void setHostOwnersDraftMessagesService(HostOwnersDraftMessagesService hostOwnersDraftMessagesService) {
        this.hostOwnersDraftMessagesService = hostOwnersDraftMessagesService;
    }
}
