package ru.yandex.wmconsole.servantlet.drafts;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.data.WMCHistoryObjectTypeEnum;
import ru.yandex.wmconsole.data.wrappers.DraftMessageWrapper;
import ru.yandex.wmconsole.data.wrappers.HostOwnersDraftMessageWrapper;
import ru.yandex.wmconsole.data.wrappers.PersonalDraftMessageWrapper;
import ru.yandex.wmconsole.service.GlobalDraftMessagesService;
import ru.yandex.wmconsole.service.HostOwnersDraftMessagesService;
import ru.yandex.wmconsole.service.PersonalDraftMessagesService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

public class DraftMessagesListServantlet extends AuthenticationServantlet {
    private static final String PARAM_SENT = "sent";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_GLOBAL = "global";

    private GlobalDraftMessagesService globalDraftMessagesService;
    private PersonalDraftMessagesService personalDraftMessagesService;
    private HostOwnersDraftMessagesService hostOwnersDraftMessagesService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {
        Boolean sentParam = getBooleanParam(req, PARAM_SENT);
        boolean sent = (sentParam != null) && sentParam;

        //compatibility with old format
        Boolean globalParam = getBooleanParam(req, PARAM_GLOBAL);
        boolean global = (globalParam != null) && globalParam;
        byte typeInt = (byte) req.getParamAsInt(PARAM_TYPE, global ?
                WMCHistoryObjectTypeEnum.GLOBAL_MESSAGE.getValue() : WMCHistoryObjectTypeEnum.PERSONAL_MESSAGE.getValue());

        WMCHistoryObjectTypeEnum type = WMCHistoryObjectTypeEnum.R.fromValueOrNull(typeInt);

        Pager pager = createOutputStrategy(req).createPager();

        switch (type) {
            case GLOBAL_MESSAGE: {
                res.addData(XmlConvertableCollectionWrapper.wrap(globalDraftMessagesService.getDraftMessagesList(pager, sent),
                        DraftMessageWrapper.class, "draft-messages"));
            }
            break;
            case PERSONAL_MESSAGE: {
                res.addData(XmlConvertableCollectionWrapper.wrap(personalDraftMessagesService.getDraftMessagesList(pager, sent),
                        PersonalDraftMessageWrapper.class, "draft-messages"));
            }
            break;
            case HOST_OWNERS_MESSAGE: {
                res.addData(XmlConvertableCollectionWrapper.wrap(hostOwnersDraftMessagesService.getDraftMessagesList(pager, sent),
                        HostOwnersDraftMessageWrapper.class, "draft-messages"));
            }
        }
        res.addData(pager);
    }

    @Required
    public void setGlobalDraftMessagesService(GlobalDraftMessagesService globalDraftMessagesService) {
        this.globalDraftMessagesService = globalDraftMessagesService;
    }

    @Required
    public void setPersonalDraftMessagesService(PersonalDraftMessagesService personalDraftMessagesService) {
        this.personalDraftMessagesService = personalDraftMessagesService;
    }

    @Required
    public void setHostOwnersDraftMessagesService(HostOwnersDraftMessagesService hostOwnersDraftMessagesService) {
        this.hostOwnersDraftMessagesService = hostOwnersDraftMessagesService;
    }
}
