package ru.yandex.wmconsole.servantlet.graphics;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.wrappers.KPIInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.KPIInfoService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * @author avhaliullin
 */
public class AvailableKPIsServantlet extends WMCAuthenticationServantlet {
    private KPIInfoService kpiInfoService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        res.addData(XmlConvertableCollectionWrapper.wrap(kpiInfoService.getAvailableKPIs(), KPIInfoWrapper.class, "kpi-list"));
    }

    @Required
    public void setKpiInfoService(KPIInfoService kpiInfoService) {
        this.kpiInfoService = kpiInfoService;
    }
}
