package ru.yandex.wmconsole.servantlet.graphics;

import java.util.Collections;
import java.util.Date;
import java.util.NavigableMap;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.IWMCUserInfoService;
import ru.yandex.wmtools.common.data.plot.DateIntegerPlotHelper;
import ru.yandex.wmtools.common.data.plot.HighchartPlotDataWrapper;
import ru.yandex.wmtools.common.data.plot.PlotHelper;
import ru.yandex.wmtools.common.data.plot.UnixTimestampDateFormat;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;
import ru.yandex.wmtools.common.util.TimeFilter;

/**
 * Created by IntelliJ IDEA.
 * Date: 27.10.2008
 * Time: 23:20:50
 * <p/>
 * Returns count of true users, i.e. users who visit our service at least once a week during last month.
 */
public class TrueUsersPlotDataServantlet extends AbstractServantlet {
    private static final String TRUE_USERS_PLOT_NAME = "true_users";

    private IWMCUserInfoService userInfoService;

    @Override
    public void doProcess(ServRequest req, ServResponse res) throws InternalException {
        DateIntegerPlotHelper plotHelper = new DateIntegerPlotHelper(PlotHelper.InterpolateMode.LINEAR);
        plotHelper.setDateFormat(new UnixTimestampDateFormat(true));
        NavigableMap<Date, Integer> date2count = userInfoService.getTrueUsersInfo(TimeFilter.createNull());
        res.addData(new HighchartPlotDataWrapper<Date, Integer>(TRUE_USERS_PLOT_NAME, Collections.singletonList(date2count)
                , Collections.singletonList("core"),
                plotHelper));
    }

    @Required
    public void setUserInfoService(final IWMCUserInfoService userInfoService) {
        this.userInfoService = userInfoService;
    }
}
