package ru.yandex.wmconsole.servantlet.graphics;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NavigableMap;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.IWMCUserInfoService;
import ru.yandex.wmtools.common.data.plot.DateIntegerPlotHelper;
import ru.yandex.wmtools.common.data.plot.HighchartPlotDataWrapper;
import ru.yandex.wmtools.common.data.plot.PlotHelper;
import ru.yandex.wmtools.common.data.plot.UnixTimestampDateFormat;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.TimeFilter;

public class UsersPlotDataServantlet extends AuthenticationServantlet {
    private static final String USERS_PLOT_NAME = "users";

    private IWMCUserInfoService userInfoService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException {
        List<NavigableMap<Date, Integer>> data = new ArrayList<NavigableMap<Date, Integer>>();
        data.add(userInfoService.getNewUsersInfo(TimeFilter.createNull()));
        data.add(userInfoService.getUsersWithHostsInfo(TimeFilter.createNull()));
        data.add(userInfoService.getUsersWithVerifiedHostsInfo(TimeFilter.createNull()));
        DateIntegerPlotHelper plotHelper =  new DateIntegerPlotHelper(PlotHelper.InterpolateMode.LINEAR);
        plotHelper.setDateFormat(new UnixTimestampDateFormat(true));
        res.addData(new HighchartPlotDataWrapper<Date, Integer>(USERS_PLOT_NAME, data, plotHelper));
    }

    @Required
    public void setUserInfoService(final IWMCUserInfoService userInfoService) {
        this.userInfoService = userInfoService;
    }
}
