package ru.yandex.wmconsole.servantlet.log.options;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.xml.wrapper.BooleanWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.LogErrorService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Сохранение настроек сохранения логов JS для пользователя
 *
 * User: azakharov
 * Date: 29.12.12
 * Time: 19:31
 */
public class LogErrorChangeServantlet extends WMCAuthenticationServantlet {
    
    private static final String PARAM_ENABLE = "enable";
    
    private LogErrorService logErrorService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        long user = getAndCheckUserIdByNameOrId(req);
        boolean enable = getRequiredCheckboxBooleanParam(req, PARAM_ENABLE);

        logErrorService.saveLogEnabled(user, enable);
        res.addData(new BooleanWrapper("enabled", enable));
    }

    @Required
    public void setLogErrorService(LogErrorService logErrorService) {
        this.logErrorService = logErrorService;
    }
}
