package ru.yandex.wmconsole.servantlet.log.options;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.xml.wrapper.BooleanWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.LogErrorService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Показ настроек сохранения логов JS для пользователя
 *
 * User: azakharov
 * Date: 29.12.12
 * Time: 19:26
 */
public class LogErrorInfoServantlet extends WMCAuthenticationServantlet {

    private LogErrorService logErrorService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        long user = getAndCheckUserIdByNameOrId(req);
        res.addData(new BooleanWrapper("enabled", logErrorService.logEnabled(user)));
    }

    @Required
    public void setLogErrorService(LogErrorService logErrorService) {
        this.logErrorService = logErrorService;
    }
}