package ru.yandex.wmconsole.servantlet.moderation.hostnames;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.data.info.DisplayNameInfo;
import ru.yandex.wmconsole.data.wrappers.DisplayNameInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.DisplayNameModerationService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

public class DisplayNameModerationListServantlet extends WMCAuthenticationServantlet {
    private static final String PARAM_NAME = "name";

    private DisplayNameModerationService displayNameModerationService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId)
            throws InternalException, UserException {

        Pager pager = createOutputStrategy(req).createPager();

        String name = getStringParam(req, PARAM_NAME);

        Collection<DisplayNameInfo> displayNameInfos =
                displayNameModerationService.getChangeDisplayNameRequests(pager, name);
        int totalCount = displayNameModerationService.getChangeDisplayNameRequestsCount(name);

        res.addData(XmlConvertableCollectionWrapper.wrap(
                        displayNameInfos,
                        DisplayNameInfoWrapper.class,
                        "change-display-name-list", "total-count", Integer.toString(totalCount)
                )
        );
        res.addData(pager);
    }

    @Required
    public void setDisplayNameModerationService(DisplayNameModerationService hostNameService) {
        this.displayNameModerationService = hostNameService;
    }
}
