package ru.yandex.wmconsole.servantlet.moderation.mainmirror;

import java.text.ParseException;
import java.util.Calendar;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.data.MainMirrorRequestStateEnum;
import ru.yandex.wmconsole.data.MainMirrorStateEnum;
import ru.yandex.wmconsole.data.info.MainMirrorRequestHistoryInfo;
import ru.yandex.wmconsole.data.wrappers.MainMirrorRequestHistoryInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.MainMirrorChangeHistoryService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.util.TimeFilter;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * @author avhaliullin
 */
public class MainMirrorChangeHistoryServantlet extends WMCAuthenticationServantlet {
    private static final String PARAM_HOST_FILTER = "host";
    private static final String PARAM_CREATED_FROM = "created_from";
    private static final String PARAM_CREATED_TO = "created_to";
    private static final String PARAM_MODIFIED_FROM = "modified_from";
    private static final String PARAM_MODIFIED_TO = "modified_to";
    private static final String PARAM_REQUEST_STATE_FILTER = "request_state";
    private static final String PARAM_STATE_FILTER = "state";

    private MainMirrorChangeHistoryService mainMirrorChangeHistoryService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        Pager pager = createOutputStrategy(req).createPager();
        TimeFilter createdTimeFilter;
        TimeFilter modifiedTimeFilter;
        try {
            createdTimeFilter = TimeFilter.create(getStringParam(req, PARAM_CREATED_FROM), getStringParam(req, PARAM_CREATED_TO), "yyyy/MM/dd", Calendar.DAY_OF_YEAR);
            modifiedTimeFilter = TimeFilter.create(getStringParam(req, PARAM_MODIFIED_FROM), getStringParam(req, PARAM_MODIFIED_TO), "yyyy/MM/dd", Calendar.DAY_OF_YEAR);
        } catch (ParseException e) {
            throw new UserException(UserProblem.ILLEGAL_PARAM_VALUE, "Illegal value of date param", e);
        }
        String hostNameFilter = getStringParam(req, PARAM_HOST_FILTER);
        Byte requestStateByte = getByteParam(req, PARAM_REQUEST_STATE_FILTER);
        Byte stateByte = getByteParam(req, PARAM_STATE_FILTER);
        MainMirrorRequestStateEnum requestState = null;
        MainMirrorStateEnum state = null;
        if (requestStateByte != null) {
            requestState = MainMirrorRequestStateEnum.R.fromValueOrNull(requestStateByte);
        }
        if (stateByte != null) {
            state = MainMirrorStateEnum.R.fromValueOrNull(stateByte);
        }

        List<MainMirrorRequestHistoryInfo> infos = mainMirrorChangeHistoryService.getHistory(
                pager,
                createdTimeFilter,
                modifiedTimeFilter,
                hostNameFilter,
                requestState,
                state);
        res.addData(XmlConvertableCollectionWrapper.wrap(infos, MainMirrorRequestHistoryInfoWrapper.class, "main-mirror-change-history"));
        res.addData(pager);
    }

    @Required
    public void setMainMirrorChangeHistoryService(MainMirrorChangeHistoryService mainMirrorChangeHistoryService) {
        this.mainMirrorChangeHistoryService = mainMirrorChangeHistoryService;
    }
}
