package ru.yandex.wmconsole.servantlet.moderation.regions;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.HostRegionService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author baton
 */
public class HostRegionModeratorIssueServantlet extends WMCAuthenticationServantlet {
    private static final String PARAM_REGION = "region";
    private static final String PARAM_COMMENT = "comment";
    private static final String PARAM_URL = "url";

    private HostRegionService hostRegionService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId)
            throws UserException, InternalException {

        BriefHostInfo hostInfo = getHostInfo(req);

        String comment = req.getParam(PARAM_COMMENT, true);
        String url = req.getParam(PARAM_URL, true);
        int region = getRequiredIntParam(req, PARAM_REGION);

        hostRegionService.moderatorIssueRegion(userId, hostInfo, region, comment, url);
    }

    @Required
    public void setHostRegionService(HostRegionService hostRegionService) {
        this.hostRegionService = hostRegionService;
    }
}
