package ru.yandex.wmconsole.servantlet.moderation.regions;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.HostRegionService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author baton
 */
public class HostRegionsWaitingDelayServantlet extends WMCAuthenticationServantlet {
    private HostRegionService hostRegionService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId)
            throws InternalException, UserException {

        BriefHostInfo hostInfo = getHostInfo(req);

        hostRegionService.delayWaiting(hostInfo.getId(), req.getUserId());
    }

    @Required
    public void setHostRegionService(HostRegionService hostRegionService) {
        this.hostRegionService = hostRegionService;
    }
}
