package ru.yandex.wmconsole.servantlet.moderation.regions;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.HostRegionChangeRequestStateEnum;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.HostRegionService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;

/**
 * @author baton
 */
public class HostRegionsWaitingResolveServantlet extends WMCAuthenticationServantlet {
    private static final String PARAM_STATE = "state";
    private static final String PARAM_COMMENT = "comment";

    private HostRegionService hostRegionService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId)
            throws UserException, InternalException {

        BriefHostInfo hostInfo = getHostInfo(req);

        String comment = req.getParam(PARAM_COMMENT, true);
        int intState = getRequiredIntParam(req, PARAM_STATE);
        HostRegionChangeRequestStateEnum state = HostRegionChangeRequestStateEnum.R.fromValueOrNull(intState);
        if (state == null) {
            throw new UserException(UserProblem.ILLEGAL_PARAM_VALUE, "Param 'state' has illegal value", PARAM_STATE, Integer.toString(intState));
        }

        if (!state.canResolveToThisState()) {
            throw new UserException(UserProblem.SUCH_VALUE_NOT_ALLOWED_HERE, "Param 'state' has illegal value", PARAM_STATE, Integer.toString(state.getValue()));
        }

        hostRegionService.resolveWaiting(hostInfo, state, req.getUserId(), comment);
    }

    @Required
    public void setHostRegionService(HostRegionService hostRegionService) {
        this.hostRegionService = hostRegionService;
    }
}
