package ru.yandex.wmconsole.servantlet.poll;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.poll.AnswerOptionInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.PollService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Добавление варианта ответа
 *
 * User: azakharov
 * Date: 19.02.13
 * Time: 12:37
 */
public class AddAnswerOptionServantlet extends WMCAuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(AddAnswerOptionServantlet.class);

    private static final String PARAM_QUESTION_ID = "question_id";
    private static final String PARAM_TEXT = "text";
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_NUMBER = "number";
    private static final String PARAM_SCORE = "score";
    private static final String PARAM_TEXT_EXPECTED  = "text_expected";

    private PollService pollService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        final long questionId = getRequiredLongParam(req, PARAM_QUESTION_ID);
        final String text = getRequiredStringParam(req, PARAM_TEXT);
        final String description = getStringParam(req, PARAM_DESCRIPTION);
        final Integer number = getRequiredIntParam(req, PARAM_NUMBER);
        final Integer score = getIntParam(req, PARAM_SCORE);
        final Boolean textExpected = getRequiredBooleanParam(req, PARAM_TEXT_EXPECTED);

        AnswerOptionInfo answerOptionInfo = new AnswerOptionInfo(
                null, questionId, text, description, number, score, textExpected);

        pollService.addAnswerOption(answerOptionInfo);
    }

    @Required
    public void setPollService(PollService pollService) {
        this.pollService = pollService;
    }
}
