package ru.yandex.wmconsole.servantlet.poll;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.PollService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Добавление вопроса к существующему опросу
 *
 * User: azakharov
 * Date: 14.02.13
 * Time: 12:02
 */
public class AddQuestionServantlet extends WMCAuthenticationServantlet {
    private static Logger log = LoggerFactory.getLogger(AddQuestionServantlet.class.getSimpleName());

    private static final String PARAM_POLL_ID = "poll_id";
    private static final String PARAM_TYPE_ID = "type_id";
    private static final String PARAM_TEXT = "text";
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_REQUIRED = "required";
    private static final String PARAM_POSITION = "position";

    private PollService pollService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        Long pollId = getRequiredLongParam(req, PARAM_POLL_ID);
        Integer typeId = getRequiredIntParam(req, PARAM_TYPE_ID);
        String text = getRequiredStringParam(req, PARAM_TEXT);
        String description = getStringParam(req, PARAM_DESCRIPTION);
        Boolean required = getRequiredBooleanParam(req, PARAM_REQUIRED);
        Integer position = getIntParam(req, PARAM_POSITION);

        pollService.addQuestion(pollId, typeId, text, description, required, position, userId);
    }

    @Required
    public void setPollService(PollService pollService) {
        this.pollService = pollService;
    }
}
