package ru.yandex.wmconsole.servantlet.poll;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.PollService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * User: azakharov
 * Date: 19.02.13
 * Time: 16:05
 */
public class DeleteAnswerOptionServantlet extends WMCAuthenticationServantlet {
    
    private static final String PARAM_OPTION_ID = "option_id";
    
    private PollService pollService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        final Long optionId = getRequiredLongParam(req, PARAM_OPTION_ID);
        pollService.deleteAnswerOption(optionId);
    }

    @Required
    public void setPollService(PollService pollService) {
        this.pollService = pollService;
    }
}
