package ru.yandex.wmconsole.servantlet.poll;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.PollService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * User: azakharov
 * Date: 26.03.12
 * Time: 17:05
 */
public class DeletePollServantlet extends WMCAuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(DeletePollServantlet.class);

    private static final String PARAM_POLL = "poll_id";

    private PollService pollService;

    @Override
    protected void doProcess(final ServRequest req, final ServResponse res, final long userId) throws UserException, InternalException {
        assertUserExists(userId);

        final long pollId = getRequiredLongParam(req, PARAM_POLL);
        pollService.deletePoll(pollId);
    }

    @Required
    public void setPollService(PollService pollService) {
        this.pollService = pollService;
    }
}
