package ru.yandex.wmconsole.servantlet.poll;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.PollService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Удаление вопроса из опроса
 *
 * User: azakharov
 * Date: 14.02.13
 * Time: 15:43
 */
public class DeleteQuestionServantlet extends WMCAuthenticationServantlet {
    
    private static final String PARAM_QUESTION_ID = "question_id";
    private static final String PARAM_POLL_ID = "poll_id";

    private PollService pollService;
    
    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        pollService.deleteQuestion(
                userId, getRequiredLongParam(req, PARAM_POLL_ID), getRequiredLongParam(req, PARAM_QUESTION_ID));
    }

    @Required
    public void setPollService(PollService pollService) {
        this.pollService = pollService;
    }
}
