package ru.yandex.wmconsole.servantlet.support;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.service.SupportUsersService;

public class AddSupportServantlet extends WMCAuthenticationServantlet {
    private SupportUsersService supportUsersService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(supportUsersService, SupportUsersService.class);
        long supportId = getUserIdByNameOrId(req, PARAM_USER);
        supportUsersService.addSupportUser(req.getUserId(), supportId);
    }

    @Required
    public void setSupportUsersService(SupportUsersService supportUsersService) {
        this.supportUsersService = supportUsersService;
    }
}
