package ru.yandex.wmconsole.servantlet.support;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.service.SupportUsersService;

public class RemoveSupportServantlet extends AuthenticationServantlet {
    private static final String PARAM_REMOVE = "remove";

    private SupportUsersService supportUsersService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(supportUsersService, SupportUsersService.class);
        Long[] supportIds = getMultiParamLong(req, PARAM_REMOVE);
        if (supportIds.length > 0) {
            supportUsersService.removeSupportUsers(req.getUserId(), supportIds);
        }
    }

    @Required
    public void setSupportUsersService(SupportUsersService supportUsersService) {
        this.supportUsersService = supportUsersService;
    }
}
