package ru.yandex.wmconsole.servantlet.support;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmtools.common.data.info.WMUserInfo;
import ru.yandex.wmtools.common.data.wrappers.UserInfoWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.service.SupportUsersService;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

public class SupportListServantlet extends AuthenticationServantlet {
    private SupportUsersService supportUsersService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(supportUsersService, SupportUsersService.class);

        Pager pager = createOutputStrategy(req).createPager();
        List<WMUserInfo> supportUsers = supportUsersService.getUserInfoListForSupportUsers(pager);
        res.addData(XmlConvertableCollectionWrapper.wrap(supportUsers, UserInfoWrapper.class, "support-users"));
        res.addData(pager);
    }

    @Required
    public void setSupportUsersService(SupportUsersService supportUsersService) {
        this.supportUsersService = supportUsersService;
    }
}
