package ru.yandex.wmconsole.servantlet.verification;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.IWMCSupportService;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

public class CheatVerifyHostServantlet extends WMCAuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(CheatVerifyHostServantlet.class);

    private IWMCSupportService supportService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {

        BriefHostInfo hostInfo = getHostInfo(req);
        supportService.cheatVerify(userId, hostInfo);
        log.debug("Cheat verify complete. hostId = " + hostInfo.getId());
        res.addData(new HostElementWrapper(null, hostInfo));
    }

    @Required
    public void setSupportService(IWMCSupportService supportService) {
        this.supportService = supportService;
    }
}
