package ru.yandex.wmconsole.servantlet.verification;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.ToolEnum;
import ru.yandex.wmconsole.data.info.LogInfo;
import ru.yandex.wmconsole.data.wrappers.LogInfoWrapper;
import ru.yandex.wmconsole.service.LogViewerService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

import java.util.List;

/**
 * User: azakharov
 * Date: 17.04.14
 * Time: 20:53
 */
public class LogExamplesServantlet extends AuthenticationServantlet {

    private static final String PARAM_TOOL = "tool";

    private LogViewerService logViewerService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {

        int toolParam = getRequiredIntParam(req, PARAM_TOOL);
        ToolEnum tool = ToolEnum.R.fromValueOrNull(toolParam);
        if (tool == null) {
            throw new UserException(UserProblem.ILLEGAL_PARAM_VALUE, "Invalid param: " + PARAM_TOOL,
                    PARAM_TOOL, Integer.toString(toolParam));
        }

        List<LogInfo> infos = logViewerService.getLogExample(tool);
        res.addData(XmlConvertableCollectionWrapper.wrap(infos, LogInfoWrapper.class, "log-infos"));
    }

    @Required
    public void setLogViewerService(LogViewerService logViewerService) {
        this.logViewerService = logViewerService;
    }

}
