package ru.yandex.wmconsole.servantlet.verification;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.IWMCSupportService;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

public class ManualVerifyHostServantlet extends WMCAuthenticationServantlet {
    private IWMCSupportService supportService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {

        BriefHostInfo hostInfo = getHostInfo(req);
        long toUserId = getAndCheckUserIdByNameOrId(req);

        supportService.manualVerify(toUserId, userId, hostInfo);
        res.addData(new HostElementWrapper(null, hostInfo));
    }

    @Required
    public void setSupportService(IWMCSupportService supportService) {
        this.supportService = supportService;
    }
}
