package ru.yandex.wmconsole.servantlet.verification;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.data.info.ShortHostInfo;
import ru.yandex.wmconsole.data.wrappers.ShortHostInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

import java.util.List;

/**
 * @author avhaliullin
 */
public class NotVerifiedHostListForUserServantlet extends WMCAuthenticationServantlet {
    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        Pager pager = createOutputStrategy(req).createPager();

        long uid = getAndCheckUserIdByNameOrId(req, "for_user");

        List<ShortHostInfo> hostList = getHostInfoService().getNotVerifiedShortHostList(uid, pager);

        res.addData(XmlConvertableCollectionWrapper.wrap(
                hostList, ShortHostInfoWrapper.class, "not-verified-host-list"));
        res.addData(pager);
    }
}
