package ru.yandex.wmconsole.servantlet.verification;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.UsersHostsInfo;
import ru.yandex.wmconsole.data.wrappers.UsersHostsInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author avhaliullin
 */
public class UserHostVerificationInfoServantlet extends WMCAuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(UserHostVerificationInfoServantlet.class);

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        long uid = getAndCheckUserIdByNameOrId(req, "for_user");
        long hostId = getRequiredLongParam(req, "host_id");

        log.debug("Checking verification for user " + uid + " and host " + hostId);

        UsersHostsInfo info = getUsersHostsService().getUsersHostsInfo(uid, hostId);

        res.addData(new UsersHostsInfoWrapper(info));
    }
}
