package ru.yandex.webmaster.viewer.http.servantlet.xml.limit;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster.common.WebmasterException;
import ru.yandex.webmaster.common.WebmasterExceptionType;
import ru.yandex.webmaster.common.http.Action;
import ru.yandex.wmconsole.data.UserDailyCounterEnum;
import ru.yandex.wmconsole.service.UserDailyCounterService;
import ru.yandex.wmconsole.service.XmlLimitsService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author aherman
 */
public class DelegateHostLimitsAction extends Action<DelegateHostLimitsRequest, DelegateHostLimitsResponse> {
    private XmlLimitsService xmlLimitsService;
    private UserDailyCounterService userDailyCounterService;

    @Override
    public DelegateHostLimitsResponse process(DelegateHostLimitsRequest request) throws InternalException,
            UserException
    {
        if (!userDailyCounterService.increment(request.getUserId(), UserDailyCounterEnum.HOST_LIMIT_DELEGATION)) {
            throw new WebmasterException(WebmasterExceptionType.XML_LIMITS__DELEGATION_LIMIT_EXCEEDED,
                    "Daily limit on delegation exceeded");
        }

        xmlLimitsService.delegateHostLimit2(request.getHostId(), request.getUserId(), request.getDelegateToUserId());
        return new DelegateHostLimitsResponse();
    }


    @Required
    public void setXmlLimitsService(XmlLimitsService xmlLimitsService) {
        this.xmlLimitsService = xmlLimitsService;
    }

    @Required
    public void setUserDailyCounterService(UserDailyCounterService userDailyCounterService) {
        this.userDailyCounterService = userDailyCounterService;
    }
}
