package ru.yandex.webmaster.viewer.http.servantlet.xml.limit;

import org.apache.commons.lang.StringUtils;

import ru.yandex.webmaster.common.http.ActionRequest;
import ru.yandex.webmaster.common.http.RequestFilter;
import ru.yandex.webmaster.common.http.RequestQueryProperty;
import ru.yandex.webmaster.common.http.request.PagerAware;
import ru.yandex.webmaster.common.http.request.UserIdAware;
import ru.yandex.webmaster.common.util.HostnamePart;
import ru.yandex.webmaster.common.util.HostnamePartUtils;
import ru.yandex.wmconsole.data.info.limits.HostLimitsOrder;

/**
 * @author aherman
 */
public class GetLimitsByFilterRequest implements ActionRequest, UserIdAware, PagerAware {
    private long userId;
    private int page;
    private int pageSize = 10;
    private String hostnameFilter;
    private HostnamePart hostnamePart = null;
    private HostLimitsOrder order = HostLimitsOrder.LIMIT_DESC;

    @Override
    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Override
    public long getUserId() {
        return userId;
    }

    @Override
    public void setP(int page) {
        this.page = page;
    }

    public int getPage() {
        return page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return pageSize;
    }

    public String getHostnameFilter() {
        return hostnameFilter;
    }

    @RequestQueryProperty()
    public void setHostnameFilter(String hostnameFilter) {
        this.hostnameFilter = hostnameFilter;
    }

    @RequestQueryProperty()
    public void setOrder(HostLimitsOrder order) {
        this.order = order;
    }

    public HostLimitsOrder getOrder() {
        return order;
    }

    public HostnamePart getHostnamePart() {
        return hostnamePart;
    }

    public void setHostnamePart(HostnamePart hostnamePart) {
        this.hostnamePart = hostnamePart;
    }

    public static class HostnameFilter implements RequestFilter {
        @Override
        public void beforeRequest(String action, Object request) {
            if (!(request instanceof GetLimitsByFilterRequest)) {
                return;
            }
            GetLimitsByFilterRequest req = (GetLimitsByFilterRequest) request;
            String hostnameFilter = StringUtils.trimToNull(req.getHostnameFilter());

            if (hostnameFilter != null) {
                HostnamePart hostnamePart = HostnamePartUtils.cleanHostnamePart(hostnameFilter);
                req.setHostnamePart(hostnamePart);
            }
        }
    }
}
