package ru.yandex.webmaster.viewer.http.servantlet.xml.limit;

import java.util.List;

import ru.yandex.webmaster.common.http.ActionResponse;
import ru.yandex.webmaster.common.http.response.HostResponse;
import ru.yandex.webmaster.common.http.response.UserResponse;
import ru.yandex.wmconsole.data.info.limits.HostsAndLimitsInfo;

/**
 * @author aherman
 */
public class GetLimitsByFilterResponse implements ActionResponse {
    private final List<HostLimit> hosts;
    private final int totalLimit;
    private final int totalHosts;
    private final int filteredHosts;
    private final int filteredLimit;

    public GetLimitsByFilterResponse(HostsAndLimitsInfo totalHostsAndLimit, HostsAndLimitsInfo filteredHostsAndLimit,
            List<HostLimit> hosts)
    {
        this.totalLimit = totalHostsAndLimit.getLimit();
        this.totalHosts = totalHostsAndLimit.getHostCount();
        this.filteredLimit = filteredHostsAndLimit.getLimit();
        this.filteredHosts = filteredHostsAndLimit.getHostCount();
        this.hosts = hosts;
    }

    public List<HostLimit> getHosts() {
        return hosts;
    }

    public int getTotalLimit() {
        return totalLimit;
    }

    public int getTotalHosts() {
        return totalHosts;
    }

    public int getFilteredLimit() {
        return filteredLimit;
    }

    public int getFilteredHosts() {
        return filteredHosts;
    }

    public static class HostLimit {
        private final int limit;
        private final HostResponse host;
        private final UserResponse limitOwner;
        private final List<UserResponse> verifiedUsers;

        public HostLimit(int limit, HostResponse host, UserResponse hostOwner,
                List<UserResponse> verifiedUsers)
        {
            this.limit = limit;
            this.host = host;
            this.limitOwner = hostOwner;
            this.verifiedUsers = verifiedUsers;
        }

        public int getLimit() {
            return limit;
        }

        public HostResponse getHost() {
            return host;
        }

        public UserResponse getLimitOwner() {
            return limitOwner;
        }

        public List<UserResponse> getVerifiedUsers() {
            return verifiedUsers;
        }
    }
}
