package ru.yandex.webmaster.viewer.view.all.about.url;

import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.webmaster.common.util.xml.SimpleXmlBuilder;

import java.util.Map;

/**
 * User: azakharov
 * Date: 24.02.14
 * Time: 18:20
 */
public class DumpAllAboutUrlTablesWrapper implements XmlConvertable {

    private final Map<String, Map<String, Object>> data;

    public DumpAllAboutUrlTablesWrapper(Map<String, Map<String, Object>> data) {
        this.data = data;
    }

    @Override
    public void toXml(StringBuilder storage) {
        final SimpleXmlBuilder xmlBuilder = new SimpleXmlBuilder(storage);

        xmlBuilder.open("dump-tables");
        for (Map.Entry<String, Map<String, Object>> entry : data.entrySet()) {
            if (entry.getValue() != null) {

                Map<String, Object> columnValues = entry.getValue();
                xmlBuilder.open(entry.getKey());
                try {
                    for (Map.Entry<String, Object> e : columnValues.entrySet()) {
                        if (e.getValue() != null) {
                            xmlBuilder.element(e.getKey(), e.getValue().toString());
                        } else {
                            xmlBuilder.element( e.getKey(), "NULL");
                        }
                    }
                } finally {
                    xmlBuilder.close();
                }
            }
        }
        xmlBuilder.close();
    }
}
