package ru.yandex.wmconsole.authorization;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import ru.yandex.wmconsole.servantlet.api.AbstractApiServantlet;

/**
 * @author aherman
 */
public class ApiOAuthAuthorizationInitializer implements ApplicationContextAware, InitializingBean {
    private ApplicationContext applicationContext;
    private ApiOAuthInfoService apiOAuthInfoService;

    @Override
    public void afterPropertiesSet() throws Exception {
        List<AbstractApiServantlet> apiServantlets = collectBeansByClass(applicationContext, AbstractApiServantlet.class);
        for (AbstractApiServantlet apiServantlet : apiServantlets) {
            ApiOAuthPermission permission = apiServantlet.getRequiredPermission();
            apiServantlet.setAuthorizationScheme(new OAuthAuthorizationScheme2(permission, apiOAuthInfoService));
        }
    }

    private static <T> List<T> collectBeansByClass(ListableBeanFactory factory, Class<T> clazz) {
        return new ArrayList<T>(factory.getBeansOfType(clazz).values());
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Required
    public void setApiOAuthInfoService(ApiOAuthInfoService apiOAuthInfoService) {
        this.apiOAuthInfoService = apiOAuthInfoService;
    }
}
